/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.world;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.util.MCDirection;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/world/MCWorld")
@NativeTypeRegistration(value=World.class, zenCodeName="crafttweaker.api.world.MCWorld")
public class ExpandWorld {
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=false)
    public static ServerWorld asServerWorld(World internal) {
        return (ServerWorld)internal;
    }

    @ZenCodeType.Getter(value="remote")
    @ZenCodeType.Method
    public static boolean isRemote(World internal) {
        return internal.field_72995_K;
    }

    @ZenCodeType.Getter(value="dayTime")
    public static boolean isDayTime(World internal) {
        return internal.func_72935_r();
    }

    @ZenCodeType.Getter(value="nightTime")
    public static boolean isNightTime(World internal) {
        return internal.func_226690_K_();
    }

    @ZenCodeType.Getter(value="gameTime")
    public static long getTime(World internal) {
        return internal.func_82737_E();
    }

    @ZenCodeType.Getter(value="timeOfDay")
    public static long getDayTime(World internal) {
        return internal.func_82737_E();
    }

    @ZenCodeType.Getter(value="seaLevel")
    public static int getSeaLevel(World internal) {
        return internal.func_181545_F();
    }

    @ZenCodeType.Getter(value="raining")
    public static boolean isRaining(World internal) {
        return internal.func_72896_J();
    }

    @ZenCodeType.Getter(value="thundering")
    public static boolean isThundering(World internal) {
        return internal.func_72911_I();
    }

    @ZenCodeType.Getter(value="hardcore")
    public static boolean isHardcore(World internal) {
        return internal.func_72912_H().func_76093_s();
    }

    @ZenCodeType.Getter(value="difficulty")
    public static String getDifficulty(World internal) {
        return internal.func_72912_H().func_176130_y().func_151526_b();
    }

    @ZenCodeType.Getter(value="difficultyLocked")
    public static boolean isDifficultyLocked(World internal) {
        return internal.func_72912_H().func_176123_z();
    }

    @ZenCodeType.Getter(value="dimension")
    public static String getDimension(World internal) {
        return internal.func_234923_W_().func_240901_a_().toString();
    }

    @ZenCodeType.Method
    public static boolean isRainingAt(World internal, BlockPos pos) {
        return internal.func_175727_C(pos);
    }

    @ZenCodeType.Method
    public static int getStrongPower(World internal, BlockPos pos) {
        return internal.func_175676_y(pos);
    }

    @ZenCodeType.Method
    public static int getRedstonePower(World internal, BlockPos pos, MCDirection direction) {
        return internal.func_175651_c(pos, direction.getInternal());
    }

    @ZenCodeType.Method
    public static int getRedstonePowerFromNeighbors(World internal, BlockPos pos) {
        return internal.func_175687_A(pos);
    }

    @ZenCodeType.Method
    public static IData getTileData(World internal, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        TileEntity te = internal.func_175625_s(pos);
        return te == null ? new MapData() : NBTConverter.convert((INBT)te.func_189515_b(nbt));
    }

    @ZenCodeType.Method
    public static boolean setBlockState(World internal, BlockPos pos, BlockState state) {
        return internal.func_175656_a(pos, state);
    }

    @ZenCodeType.Method
    public static BlockState getBlockState(World internal, BlockPos pos) {
        return internal.func_180495_p(pos);
    }

    @ZenCodeType.Method
    public static boolean isBlockPowered(World internal, BlockPos pos) {
        return internal.func_175640_z(pos);
    }

    @ZenCodeType.Method
    public static Biome getBiome(World internal, BlockPos pos) {
        return internal.func_226691_t_(pos);
    }

    @ZenCodeType.Method
    public static boolean destroyBlock(World internal, BlockPos pos, boolean doDrops) {
        return internal.func_175655_b(pos, doDrops);
    }

    @ZenCodeType.Method
    public static boolean destroyBlock(World internal, BlockPos pos, boolean doDrops, @Nullable Entity breaker) {
        return internal.func_225521_a_(pos, doDrops, breaker);
    }

    @ZenCodeType.Method
    public static void playEvent(World internal, int eventId, BlockPos pos, int data) {
        internal.func_217379_c(eventId, pos, data);
    }

    @ZenCodeType.Method
    public static void playEvent(World internal, @Nullable PlayerEntity excluded, int eventId, BlockPos pos, int data) {
        internal.func_217378_a(excluded, eventId, pos, data);
    }

    @ZenCodeType.Method
    public static boolean isAir(World internal, BlockPos pos) {
        return internal.func_175623_d(pos);
    }

    @ZenCodeType.Method
    public static boolean isLoaded(World internal, BlockPos pos) {
        return internal.func_175667_e(pos);
    }

    @ZenCodeType.Method
    public static List<Entity> getEntitiesInArea(World internal, double x1, double y1, double z1, double x2, double y2, double z2) {
        return internal.func_217357_a(Entity.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
    }

    @ZenCodeType.Method
    public static List<Entity> getEntitiesInArea(World internal, BlockPos pos1, @ZenCodeType.Optional BlockPos pos2) {
        if (pos2 == null) {
            return internal.func_217357_a(Entity.class, new AxisAlignedBB(pos1));
        }
        return internal.func_217357_a(Entity.class, new AxisAlignedBB(pos1, pos2));
    }

    @ZenCodeType.Method
    public static List<Entity> getEntitiesInAreaExcluding(World internal, @ZenCodeType.Nullable Entity excludingEntity, double x1, double y1, double z1, double x2, double y2, double z2, Predicate<Entity> predicate) {
        return internal.func_175674_a(excludingEntity, new AxisAlignedBB(x1, y1, z1, x2, y2, z2), predicate);
    }

    @ZenCodeType.Method
    public static List<Entity> getEntitiesInAreaExcluding(World internal, @ZenCodeType.Nullable Entity excludingEntity, Predicate<Entity> predicate, BlockPos pos1, @ZenCodeType.Optional BlockPos pos2) {
        if (pos2 == null) {
            return internal.func_175674_a(excludingEntity, new AxisAlignedBB(pos1), predicate);
        }
        return internal.func_175674_a(excludingEntity, new AxisAlignedBB(pos1, pos2), predicate);
    }

    @ZenCodeType.Method
    public static @ZenCodeType.Nullable TileEntity getTileEntity(World internal, BlockPos pos) {
        return internal.func_175625_s(pos);
    }

    @ZenCodeType.Method
    public static boolean addEntity(World internal, Entity entity) {
        return internal.func_217376_c(entity);
    }

    @ZenCodeType.Getter(value="random")
    public static Random getRandom(World internal) {
        return internal.field_73012_v;
    }
}

